
/*

navigate.js
code for navigating MIX simulator
jeremy@mantissa, 2005

*/

//
inlets = 1;
outlets = 3;
setoutletassist(0, "to render");
setoutletassist(1, "position");
setoutletassist(2, "rotation");

// initial vectors
Pos = new Array(0.0, 0.0, 0.0);
ViewDir = new Array(0.0, 0.0, 1.0);
RightVector = new Array(1.0, 0.0, 0.0);
UpVector =  new Array(0.0, 1.0, 0.0);

// initial variables
var RotatedX = 0.0;
var RotatedY = 0.0;
var RotatedZ = 0.0;
var Distance = 0;

// set constants
var PIdiv180 = Math.PI/180.0;

function moveFwd(amt) {
	
	add = new Array(ViewDir[0]*-amt, ViewDir[1]*-amt, ViewDir[2]*-amt);
	
	newpos = new Array(Pos[0] + add[0], Pos[1] + add[1], Pos[2] + add[2]);
	
	Pos = newpos;
	
	outlet(1, Pos);
	
}

function moveUpward(amt) {

	add = new Array(UpVector[0]*amt, UpVector[1]*amt, UpVector[2]*amt);

	newpos = new Array(Pos[0] + add[0], Pos[1] + add[1], Pos[2] + add[2]);
	
	Pos = newpos;
	
	outlet(1, Pos);

}

function strafeRight(amt) {
	
	add = new Array(RightVector[0]*amt, RightVector[1]*amt, RightVector[2]*amt);

	newpos = new Array(Pos[0] + add[0], Pos[1] + add[1], Pos[2] + add[2]);
	
	Pos = newpos;
	
	outlet(1, Pos);
}

function getVectorLength(vector) {

	var v1 = vector[0];
	var v2 = vector[1];
	var v3 = vector[2];

	var len = Math.sqrt(Math.pow(v1,2)+Math.pow(v2,2)+Math.pow(v3,2));
	//var len = (Math.sqrt(Math.pow(v1,2)))+(Math.sqrt(Math.pow(v2,2)))+(Math.sqrt(Math.pow(v3,2)));
	
	return len;
}

function normalizeVector(vector) {

	var vecLength = getVectorLength(vector);
	
	tmpvec = new Array(vector[0]/vecLength, vector[1]/vecLength, vector[2]/vecLength);
	vector = tmpvec;

	return vector;
}

function rotateX(angle) {

	
	RotatedX += angle;
	
	var cos1 = Math.cos(angle*PIdiv180);
	var sin1 = Math.sin(angle*PIdiv180);
	
	tempDir = new Array(ViewDir[0]*cos1, ViewDir[1]*cos1, ViewDir[2]*cos1);
	tempVec = new Array(UpVector[0]*sin1, UpVector[1]*sin1, UpVector[2]*sin1);
	
	newVec = new Array(tempDir[0]+tempVec[0], tempDir[1]+tempVec[1], tempDir[2]+tempVec[2]);
	
	//Rotate viewdir around the right vector:
	ViewDir = normalizeVector(newVec);

	//now compute the new UpVector (by cross product)
	UpVector = crossProduct(ViewDir, RightVector);
	tempVec = new Array(UpVector[0]*-1.0, UpVector[1]*-1.0, UpVector[2]*-1.0);
	UpVector = tempVec;
	
	outputRotation();
}

function rotateY(angle) {
	
	RotatedY += angle;
	
	var cos1 = Math.cos(angle*PIdiv180);
	var sin1 = Math.sin(angle*PIdiv180);
	
	tempDir = new Array(ViewDir[0]*cos1, ViewDir[1]*cos1, ViewDir[2]*cos1);
	tempVec = new Array(RightVector[0]*sin1, RightVector[1]*sin1, RightVector[2]*sin1);
	
	newVec = new Array(tempDir[0]-tempVec[0], tempDir[1]-tempVec[1], tempDir[2]-tempVec[2]);
	
	//Rotate viewdir around the right vector:
	ViewDir = normalizeVector(newVec);

	//now compute the new UpVector (by cross product)
	RightVector = crossProduct(ViewDir, UpVector);
	
	outputRotation();
}

function rotateZ(angle) {
	
	RotatedZ += angle;
	
	var cos1 = Math.cos(angle*PIdiv180);
	var sin1 = Math.sin(angle*PIdiv180);
	
	tempDir = new Array(RightVector[0]*cos1, RightVector[1]*cos1, RightVector[2]*cos1);
	tempVec = new Array(UpVector[0]*sin1, UpVector[1]*sin1, UpVector[2]*sin1);
	
	newVec = new Array(tempDir[0]+tempVec[0], tempDir[1]+tempVec[1], tempDir[2]+tempVec[2]);
	
	//Rotate viewdir around the right vector:
	RightVector = normalizeVector(newVec);

	//now compute the new RightVector (by cross product)
	UpVector = crossProduct(ViewDir, RightVector);
	tempVec = new Array(UpVector[0]*-1.0, UpVector[1]*-1.0, UpVector[2]*-1.0);
	UpVector = tempVec;
	
	
	outputRotation();
}

function crossProduct(vec1, vec2) {
	
	var vecx = (vec1[1] * vec2[2]) - (vec1[2] * vec2[1]);
	var vecy = (vec1[2] * vec2[0]) - (vec1[0] * vec2[2]);
	var vecz = (vec1[0] * vec2[1]) - (vec1[1] * vec2[0]);
	
	crossProd = new Array(vecx, vecy, vecz);
	
	return crossProd;
}


function updateRotation(){

	rotateX(0);
	rotateY(0);
	rotateZ(0);	
}

function output(){

	tmpView = new Array(ViewDir[0]+Pos[0], ViewDir[1]+Pos[1], ViewDir[2]+Pos[2]);
	
	outlet(0, "lookat", tmpView);
	outlet(0, "camera", Pos);
	outlet(0, "up", UpVector);
}

function loadbang(){

	rotateX(180);
	updateRotation();
	output();

}

function outputPosition(){

	outlet(1, Pos);
}

function outputRotation(){

	outlet(2, RotatedX, RotatedY, RotatedZ);
}

function resetRotation(){

	ViewDir = new Array(0.0, 0.0, 1.0);
	RightVector = new Array(1.0, 0.0, 0.0);
	UpVector =  new Array(0.0, 1.0, 0.0);

	RotatedX = 0;
	RotatedY = 0;
	RotatedZ = 0;
	
	rotateX(0);
	rotateY(0);
	rotateZ(0);
}

function resetRotation2(){

	ViewDir = new Array(0.0, 0.0, 1.0);
	RightVector = new Array(1.0, 0.0, 0.0);
	UpVector =  new Array(0.0, 1.0, 0.0);

	RotatedX = 0;
	RotatedY = 0;
	RotatedZ = 0;
}